import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
	initEvent.blockTypeRegistry.registerCustomComponent('v360:rainbow_crystal', {
		onPlayerDestroy({ block, player }) {
			const spawnItemStack = new ItemStack('v360:rainbow_shard', 2);
			const selectedItem = player.getComponent('equippable').getEquipment('Mainhand');
			const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
			if (isPickaxe && player.getGameMode() !== "creative") {
				system.run(() => {
					block.dimension.spawnItem(spawnItemStack, block.location)
				})
			}
		}
	})
})